<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Teacher extends Model 
{

    protected $table = 'Teachers';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'mobile', 'specialization_id', 'gender_id', 'personal_id', 'joining_date', 'address', 'status');

    public function genderRelation()
    {
        return $this->belongsTo('App\Models\Gender', 'gender_id');
    }

    public function specializationRelation()
    {
        return $this->belongsTo('App\Models\Specialization', 'Specialization_id');
    }

    public function teacherClassroomRelation()
    {
        return $this->belongsToMany('App\Models\Classroom', 'Classroom_Teacher');
    }

}